"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@nestjs/core");
const swagger_1 = require("@nestjs/swagger");
const app_module_1 = require("./app.module");
const nestjs_api_reference_1 = require("@scalar/nestjs-api-reference");
async function bootstrap() {
    const app = await core_1.NestFactory.create(app_module_1.AppModule);
    const config = new swagger_1.DocumentBuilder()
        .setTitle('Cats example')
        .setDescription('The cats API description')
        .setVersion('1.0')
        .addTag('cats')
        .build();
    const document = swagger_1.SwaggerModule.createDocument(app, config);
    app.use('/', (0, nestjs_api_reference_1.apiReference)({
        spec: {
            content: document,
        },
    }));
    await app.listen(3006, () => {
        console.log('🦁 NestJS listening at http://localhost:3006/reference');
    });
}
bootstrap();
//# sourceMappingURL=main.js.map